<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/VAT_14.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" xmlns:tp="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Types.xsd" xmlns:tr="https://puesc.gov.pl/ZEFIR2/xsd/v12_0/Trader.xsd" xmlns:vat14="https://puesc.gov.pl/ZEFIR2/xsd/v5_0/VAT_14.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="UTF-8" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:value-of select="name()"/></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_vat14" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_vat14"><xsl:for-each select=" ns1:Header |  ns4:* | vat14:Header | tr:* "><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:apply-templates mode="PodstawaPrawna" select="."/><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:apply-templates mode="MiejsceDekl" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika" select="."/><!-- SZABLON DOT. KWOTY PODATKU --><xsl:apply-templates mode="KwotaPodatku" select="."/><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:apply-templates mode="OswPodatnika" select="."/><!-- SZABLON DOT. ADNOTACJI--><!-- <xsl:apply-templates mode="Adnotacje" select="."/> --><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:apply-templates mode="Pouczenie" select="."/><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:apply-templates mode="ObjasnieniaAkc" select="."/><!-- SZABLON DOT. WYROBOW --><xsl:apply-templates mode="NowaStrona_Zal" select="."/><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI ZAŁĄCZNIK --><xsl:apply-templates mode="rodz_dekl_zal" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC ZAŁACZNIK--><xsl:apply-templates mode="rok_mc_zal" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika_Zal" select="."/><!-- SZABLON DOT. WYROBOW --><xsl:apply-templates mode="Wyroby" select="."/></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" height="45" valign="top"><td align="left" height="45" valign="top" width="auto"><span class="cz10"><b>1. Identyfikator podatkowy NIP podatnika/płatnika </b><br/><b><span class="cz16"><xsl:value-of select="@identifier"/></span></b></span></td><td align="left" bgcolor="#CCCCCC" height="45" valign="top" width="auto"><b>2. Nr dokumentu</b><br/><br/><span class="cz12"><b><xsl:value-of select="@selfRef"/></b></span></td><td align="left" bgcolor="#CCCCCC" height="45" valign="top" width="auto"><b>3. Status</b><br/></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:* | vat14:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">VAT-14</span></td></tr><tr><td><div align="center"><span class="nag1">DEKLARACJA O NALEŻNYCH KWOTACH PODATKU OD TOWARÓW I USŁUG W PRZYPADKU WEWNĄTRZWSPÓLNOTOWEGO NABYCIA TOWARÓW, O KTÓRYM MOWA W ART. 103 UST.5A USTAWY Z DNIA 11 MARCA 2004 R. O PODATKU OD TOWARÓW I USŁUG</span><br/><span class="nag1"/></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc"><table border="1" width="955"><tr><td height="49" width="227"/><td align="left" valign="top" width="135"><b>4. Miesiąc</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(//@period,6,7)"/></div></td><td align="left" valign="top" width="131"><b>5. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(//@period,1,4)"/></div></td><td width="226"/><!-- <td align="left" valign="top" width="226"> <b>6. Liczba załaczników VAT-14/A<sub>1)</sub> </b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> --></tr></table></xsl:template><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:template match="*" mode="PodstawaPrawna"><xsl:if test="ns1:* | vat14:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td align="left" valign="top" width="115">Podstawa prawna: </td><td align="left" valign="top" width="824">Art. 99 ust. 11a ustawy z dnia 11 marca 2004 r. o podatku od towarów i usług (Dz. U. z 2022 r. poz. 931, z późn. zm.) zwanej dalej "ustawą".</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Składający:</td><td align="left" valign="top">Podatnicy lub płatnicy, o których mowa w art. 99 ust. 11a ustawy. </td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Termin składania:</td><td align="left" valign="top">Do 5. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek zapłaty podatku. </td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Miejsce składania: </td><td align="left" valign="top">Naczelnik urzędu skarbowego właściwy w sprawie rozliczania podatku akcyzowego.</td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><xsl:if test="ns1:* | vat14:*"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><span class="nag1">A. MIEJSCE I CEL SKŁADANIA DEKLARACJI</span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="4" width="46"/><td colspan="2"><b>6.Naczelnik urzędu skarbowego, do którego jest adresowana deklaracja</b><br/><span class="cz18"><xsl:value-of select="@taxOfficeName"/></span></td></tr><tr><td class="style3" colspan="2"><b>7. Cel złożenia formularza</b> (zaznaczyć właściwy kwadrat):  </td></tr><tr><xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"><td align="left" valign="top" width="422">1. złożenie deklaracji<br/><span class="cz18"> ☑ </span></td><td align="left" valign="top" width="471">2. korekta deklaracji<sup>1)</sup><br/><span class="cz18"> ☐ </span></td></xsl:if><xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"><td align="left" valign="top" width="422">1. złożenie deklaracji<br/><span class="cz18"> ☐ </span></td><td align="left" valign="top" width="471">2. korekta deklaracji<sup>1)</sup><br/><span class="cz18"> ☑ </span><br/><xsl:value-of select="@justification"/></td></xsl:if></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:template match="*" mode="DanePodatnika"><xsl:if test="ns1:* | vat14:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">B. DANE IDENTYFIKACYJNE PODATNIKA/PŁATNIKA</span><br/> *- dotyczy podmiotu niebędącego osobą fizyczną     **- dotyczy podmiotu będącego osobą fizyczną </td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="4" height="27" valign="top"><b>8. Rodzaj podmiotu </b> (zaznaczyć właściwe kwadraty):
					</td></tr><tr><td align="left" valign="top">1. Podmiot niebędący osobą fizyczną <br/><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"><div align="right" class="cz12" valign="top"><b>☐</b></div></xsl:if></td><td align="left" valign="top">2. Osoba fizyczna <br/><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"><div align="right" class="cz12" valign="top"><b>☐</b></div></xsl:if></td><td align="left" valign="top">3. Podatnik <br/><xsl:if test="//@podatnik and normalize-space(//@podatnik)='true'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if></td><td align="left" valign="top">4. Płatnik <br/><xsl:if test="//@platnik and normalize-space(//@platnik)='true'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if></td></tr><tr><td align="left" colspan="4" valign="top"><b>9.Nazwa pełna * / Nazwisko, pierwsze imię **</b><br/><br/><span class="cz18"><xsl:value-of select="//@fullName"/></span><!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> --><span class="cz18"><xsl:value-of select="//@firstName"/></span><span class="cz18"><xsl:value-of select="//@surname"/></span><span class="cz18"><xsl:value-of select="//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select="//@PESEL"/></span></td></tr><!-- <tr>  <td width="40"  bgcolor="#CCCCCC"> </td> <td colspan = "4" align="left" valign="top"><b>11. Urząd skarbowy, przy pomocy którego właściwy dla podatnika/płatnika naczelnik urzedu skarbowego wykonuje swoje zadania</b><br></br><br></br> <span class="cz18"><xsl:value-of select="//@taxOffice"/></span>  </td>  </tr> --></table></xsl:if></xsl:template><!-- SZABLON DOT. KWOTY PODATKU --><xsl:template match="ns1:Header | vat14:*" mode="KwotaPodatku"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">C. PODATEK OD TOWARÓW I USŁUG OD WEWNĄTRZWSPÓLNOTOWEGO NABYCIA TOWARÓW, O KTÓRYM MOWA W ART. 103 UST. 5A USTAWY</span><br/></td></tr><tr><td bgcolor="#CCCCCC" rowspan="4" width="40"><p/><p/><p/><p/></td><td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="410"><b>Razem podatek w zł </b>(ogółem za miesiąc, którego dotyczy deklaracja) 
					<br/><br/><br/><br/><br/>
					Podatek od towarów i usług wykazany w poz. 9 załącznika VAT-14/A.</td><td align="left" colspan="2" valign="top" width="340"><b>10.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/></div></td></tr></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:* | vat14:* | tp:*"><table border="1" height="auto" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="5"><b><span class="nag1">D. PODPIS PODATNIKA/PŁATNIKA LUB OSOBY ICH REPREZENTUJĄCEJ</span></b><br/></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>11. Imię </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="402"><b> 12. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname "/></span><td width="402" colspan="2" rowspan="2"><b> 13. Podpis podatnika/płatnika lub osoby reprezentującej podatnika/płatnika </b></td></td></tr><tr align="left" valign="top"><td height="37" width="402"><b>14. Telefon kontaktowy, e-mail </b><br/><span class="cz18"><xsl:value-of select="//@phone"/></span>
					&#160;&#160;
						<span class="cz18"><xsl:value-of select="//@email"/></span></td><td height="37" width="402"><b>15. Data wypełnienia (dzień-miesiąc-rok) </b><br/><br/><br/><span class="cz18"><xsl:value-of select="//@declarationDate"/></span></td></tr><tr align="left" valign="top">
</tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:* | vat14:*"><table border="1" height="165" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="3" height="36"> E. ADNOTACJE URZĘDU CELNEGO </td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>17. Uwagi urzędu celnego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>18. Identyfikator przyjmującego formularz <br/><br/><br/></b><p/></td><td width="421"><b>19. Podpis przyjmującego formularz </b></td></tr></table><p>1) Załącznik VAT-14/A stanowi integralną część deklaracji VAT-14. <br/> 2) Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2015 r. poz. 613, z późn. zm.).</p><br/><br/></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="Pouczenie"><xsl:if test="ns1:* | vat14:*"><table width="955"><tr><td><p><sup>1) Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2022 r. poz. 2651, z późn. zm.).</sup><br/></p><p align="center"><b> Pouczenia </b></p><p>W przypadku niewpłacenia w obowiązujących terminach podatku z poz. 10 lub wpłacenia go w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z art. 3a § 1 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2022 r. poz. 479, z późn. zm.). Niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego również na członka grupy VAT zgodnie z art. 3b § 2 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji.</p><br/><p>
						Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie, a także uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.
						</p></td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1">VAT-14</span><sub style="cz9">(4)</sub><b style="nag1">1/2</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:* | vat14:*"><table width="955"><tr><td><p align="center"><b>Objaśnienia do:</b><b/></p><p>1) deklaracji VAT-14:<br/><p> - jeżeli składający deklarację występuje w charakterze podatnika i płatnika, to składa jedną deklarację za dany okres rozliczeniowy;  należy zaznaczyć w <b>poz. 8</b> kwadraty nr 3 i 4,</p><p> - w <b>poz. 10</b> należy wpisać łączną kwotę podatku stanowiącą sumę kwot cząstkowych, które winny być wpłacone zgodnie z art. 103 ust. 5a i 5ac ustawy,</p><p>- w <b>poz. 14</b> podanie informacji jest dobrowolne.</p><p>2) Załącznika VAT-14/A <b>„ROZLICZENIE WEWNĄTRZWSPÓLNOTOWEGO NABYCIA TOWARÓW, O KTÓRYM MOWA W ART. 103 UST. 5A USTAWY”:</b></p><br/><p>-	tabelę z części B załącznika należy wypełnić chronologicznie według dat transakcji,</p><p>-	wiersze tabeli części <b>B</b> załącznika stanowią listę rozwijalną,</p><p>-	<b>kolumny b,  c,</b> oraz <b>k</b>  wypełnia się tylko wówczas, jeżeli składający deklarację występuje w charakterze płatnika,</p><p>-	jeżeli składający deklarację występuje w charakterze podatnika i płatnika (w poz. 4 zaznaczono  kwadraty nr 3 i 4), to w przypadku transakcji dokonanej na własną rzecz w <b>kolumnie d</b> należy zaznaczyć kwadrat znakiem X; w pozostałych przypadkach <b>kolumny d</b>  nie wypełnia się,</p><p>-	<b>kolumnę e</b> wypełnia się tylko w przypadku zastosowania procedury zawieszenia poboru akcyzy,</p><p>-	w <b> kolumnie f</b> należy wpisać datę transakcji powodującej powstanie obowiązku zapłaty podatku; przez datę transakcji należy rozumieć datę, od której liczy się termin wpłaty podatku zgodnie z art. 103 ust. 5a ustawy,</p><p>-	w <b>kolumnie g</b> należy wpisać datę wystawienia faktury przez podatnika podatku od wartości dodanej, dokumentującej dokonanie dostawy towarów będących przedmiotem wewnątrzwspólnotowego nabycia; w przypadku nieposiadania informacji o dacie wystawienia faktury <b>kolumny g</b> nie wypełnia się,</p><p>-	w <b>kolumnie i</b> należy wpisać wartość transakcji bez kwoty podatku, stanowiącą podstawę opodatkowania; jeżeli w danym dniu było więcej transakcji z tym samym kontrahentem,
z zastrzeżeniem że w przypadku płatnika transakcje te są rozliczane na rzecz tego samego podatnika, to można podać sumę wartości tych transakcji (z tego samego dnia) pod warunkiem, że transakcje te dotyczą wyrobu o tym samym kodzie CN, </p><p>-	w <b>kolumnie j</b> należy podać kwotę podatku należnego od wyszczególnionych w kolumnie i transakcji,</p><p>-	w <b>kolumnie k</b> należy wpisać kwotę zryczałtowanego wynagrodzenia płatnika z tytułu terminowego wpłacania podatku zgodnie z art. 28 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa,</p><p>-	w <b>kolumnie l</b> w ostatnim wierszu dla transakcji z tego samego dnia należy wpisać łączną kwotę podatku dla transakcji z tego samego dnia po pomniejszeniu o łączną
kwotę zryczałtowanego wynagrodzenia płatnika z <b>kolumny k</b> dla transakcji z tego samego dnia, które przysługuje płatnikowi zgodnie z art. 28 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa; jeżeli rozliczenia dokonuje podatnik, kwota podatku wykazana w kolumnie l równa się kwocie podatku wykazanej w kolumnie j,</p><p>-	suma kwot z <b>poz. 7 </b> powinna być równa sumie kwot z poz. <b>8</b> i <b>9</b> załącznika. </p></p></td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1">VAT-14</span><sub style="cz9">(4)</sub><b style="nag1">2/2</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl_zal"><xsl:if test="ns1:* | vat14:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">VAT-14/A</span></td></tr><tr><td><div align="center"><span class="nag1">ROZLICZENIE WEWNĄTRZWSPÓLNOTOWEGO NABYCIA TOWARÓW, O KTÓRYM MOWA W ART. 103 UST. 5A USTAWY</span><br/><span class="nag1"/></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc_zal"><table border="1" width="955"><tr><td height="49" width="227"/><td align="left" valign="top" width="135"><b>2. Miesiąc</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(//@period,6,7)"/></div></td><td align="left" valign="top" width="131"><b>3. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(//@period,1,4)"/></div></td><td width="226"/><!--<td align="left" valign="top" width="226"> <b>4. Nr załącznika</b> <br/> <div align="center" class="cz18"> <xsl:value-of select=".//@formNo"/> </div> </td> --></tr></table><table width="955"><tr bgcolor="#CCCCCC"><td><span class="cz12">Załącznik VAT-14/A stanowi integralną cześć deklaracji VAT-14.</span></td></tr></table></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:template match="*" mode="DanePodatnika_Zal"><xsl:if test="ns1:* | vat14:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="5"><span class="nag1">A. DANE IDENTYFIKACYJNE PODATNIKA/PŁATNIKA</span><br/> *- dotyczy podmiotu niebędącego osobą fizyczną     **- dotyczy podmiotu będącego osobą fizyczną </td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="4" height="27" valign="top"><b>4. Rodzaj podmiotu</b> (zaznaczyć właściwe kwadraty): 
					</td></tr><tr><td align="left" valign="top">1. Podmiot niebędący osobą fizyczną <br/><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"><div align="right" class="cz12" valign="top"><b>☐</b></div></xsl:if></td><td align="left" valign="top">2. Osoba fizyczna <br/><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='F'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if><xsl:if test="//@typeOfTaxpayer and normalize-space(//@typeOfTaxpayer)='N'"><div align="right" class="cz12" valign="top"><b>☐</b></div></xsl:if></td><td align="left" valign="top">3. Podatnik <br/><xsl:if test="//@podatnik and normalize-space(//@podatnik)='true'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if></td><td align="left" valign="top">4. Płatnik <br/><xsl:if test="//@platnik and normalize-space(//@platnik)='true'"><div align="right" class="cz12" valign="top"><b>☑</b></div></xsl:if></td></tr><tr><td align="left" colspan="4" valign="top"><b>5.Nazwa pełna * /Nazwisko, pierwsze imię **</b><br/><br/><br/><br/><br/><span class="cz18"><xsl:value-of select="//@fullName"/></span><!-- <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> --><span class="cz18"><xsl:value-of select="//@firstName"/></span><span class="cz18"><xsl:value-of select="//@surname"/></span><!-- <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> --><span class="cz18"><xsl:value-of select="//@PESEL"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON LAMANIA STRONY PRZED KAZDYM ZALACZNIKIEM --><xsl:template match="*" mode="NowaStrona_Zal"><!-- tymczasowo --><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"><!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select="." mode = "stopka"/></b></span> </td> </tr> </table> --></div></xsl:template><!-- SZABLON DOT. WYROBOW --><xsl:template match="ns1:* | vat14:*" mode="Wyroby"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td class="nag1" colspan="11">B. WEWNĄTRZWSPÓLNOTOWE NABYCIE TOWARÓW, O KTÓRYM MOWA W ART. 103 UST. 5A USTAWY</td></tr><tr align="center" bgcolor="#CCCCCC" valign="middle"><td>Lp.</td><td>Nazwa podatnika, na rzecz którego płatnik dokonuje rozliczenia</td><td>NIP podatnika </td><td>Transakcja własna</td><td>Numer akcyzowy: składu podatkowego /<br/>zarejestrowanego odbiorcy</td><td>Data transakcji   (dzień-miesiąc-rok) </td><td>Data wystawienia faktury   (dzień-miesiąc-rok) </td><td>Ośmiocyfrowy kod CN</td><td>Wartość transakcji w zł</td><td>Podatek należny w zł</td><td>Zryczałtowane wynagrodzenie płatnika w zł</td><td>Podatek należny pomniejszony o zryczałtowane wynagrodzenie płatnika w zł</td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td><div align="center">a</div></td><td><div align="center">b</div></td><td><div align="center">c</div></td><td><div align="center">d</div></td><td><div align="center">e</div></td><td><div align="center">f</div></td><td><div align="center">g</div></td><td><div align="center">h</div></td><td><div align="center">i</div></td><td><div align="center">j</div></td><td><div align="center">k</div></td><td><div align="center">l</div></td></tr><xsl:for-each select="//ns1:Item | //vat14:Item"><tr align="left" valign="top"><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@id"/></div></td><td><div align="left" class="cz12" valign="top"><xsl:value-of select="@nameOfTaxpayer"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@nip"/></div></td><td><xsl:if test="@selfTrade and normalize-space(@selfTrade)='true'"><div align="right" class="cz12" valign="top"><b>X</b></div></xsl:if></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@userNo"/></div></td><td><div align="left" class="cz12" valign="top"><xsl:value-of select="@transactionDate"/></div></td><td><div align="left" class="cz12" valign="top"><xsl:value-of select="@dateOfInvoice"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@codeCN"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@transactionValue"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@amountofTax"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@amountofFlatSalary"/></div></td><td><div align="right" class="cz12" valign="top"><xsl:value-of select="@taxChargeable"/></div></td></tr></xsl:for-each><tr align="left" valign="top"><td bgcolor="#CCCCCC" colspan="8"><b>Suma kwot z poszczególnych wierszy</b></td><td><b>6.</b><br/><div align="right" class="cz12" valign="top"><xsl:value-of select="format-number(number(*/@transactionsValueTotal),'# ##0')"/></div></td><td><b>7.</b><br/><div align="right" class="cz12" valign="top"><xsl:value-of select="format-number(number(*/@amountofTaxTotal),'# ##0')"/></div></td><td><b>8.</b><br/><div align="right" class="cz12" valign="top"><xsl:value-of select="format-number(number(*/@amountofFlatSalaryTotal),'# ##0')"/></div></td><td><b>9.</b><br/><div align="right" class="cz12" valign="top"><xsl:value-of select="format-number(number(*/@totalAmountOfTax),'# ##0')"/></div></td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">VAT-14/A</span><sub style="cz9">(4)</sub><b style="nag1">/1</b></td></tr></table></xsl:template><!-- KONIEC all AG--></xsl:stylesheet>